
import gurobi as gp
from gurobi import GRB

# Create a new model
model = gp.Model("Gardening_Company_Optimization")

# Define the variables
x1 = model.addVar(vtype=GRB.INTEGER, name="newcomers")  # Number of newcomers
x2 = model.addVar(vtype=GRB.INTEGER, name="full_time_employees")  # Number of full-time employees

# Objective: Minimize the wage bill
model.setObjective(400 * x1 + 700 * x2, GRB.MINIMIZE)

# Constraints
model.addConstr(x1 + x2 >= 100, name="total_gardeners")  # At least 100 gardeners
model.addConstr(x2 >= 40, name="min_full_time")  # At least 40 full-time employees
model.addConstr(x2 >= 0.5 * x1, name="supervision_requirement")  # Full-time employees >= half of newcomers

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Newcomers: {x1.varValue}")
    print(f"Full-time employees: {x2.varValue}")
    print(f"Minimum wage bill: ${400 * x1.varValue + 700 * x2.varValue}")
else:
    print("No optimal solution found.")
