
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("engineer_hiring")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="computer_engineers")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="software_engineers")

# Set objective function
m.setObjective(1000*x + 800*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + y >= 50, "total_engineers")
m.addConstr(x >= 10, "min_computer_engineers")
m.addConstr(y >= 2*x, "software_engineer_proportion")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Computer Engineers: {x.x}")
    print(f"Number of Software Engineers: {y.x}")
    print(f"Total Cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

