
from gurobipy import *

# Create a new model
m = Model("Engineer_Hiring")

# Define the variables
x = m.addVar(vtype=GRB.INTEGER, name="computer_engineers")
y = m.addVar(vtype=GRB.INTEGER, name="software_engineers")

# Set the objective function (minimize labor cost)
m.setObjective(1000*x + 800*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + y >= 50, "total_engineers")
m.addConstr(x >= 10, "computer_engineer_min")
m.addConstr(y >= 2*x, "software_to_computer_ratio")

# Optimize the model
m.optimize()

# Print out the results if the model is feasible
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Computer Engineers: {x.x}")
    print(f"Software Engineers: {y.x}")
    print(f"Total Labor Cost: ${1000*x.x + 800*y.x:.2f}")
else:
    print("Model is infeasible")
