
import gurobi

def solve_engineer_hiring_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(lb=0, name="Computer_Engineers")  # Number of computer engineers
    S = model.addVar(lb=0, name="Software_Engineers")  # Number of software engineers

    # Objective function: Minimize total labor cost
    model.setObjective(1000*C + 800*S, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(C + S >= 50, name="Total_Engineers")  # At least 50 engineers in total
    model.addConstr(C >= 10, name="Min_Computer_Engineers")  # At least 10 computer engineers
    model.addConstr(S >= 2*C, name="Software_to_Computer_Ratio")  # Software engineers at least twice computer engineers

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Number of Computer Engineers: {C.varValue}")
        print(f"Number of Software Engineers: {S.varValue}")
        print(f"Total Labor Cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_engineer_hiring_problem()
