
import gurobipy as gp

# Create a new model
m = gp.Model("PancakeWaffle")

# Create variables
pancakes = m.addVar(vtype=gp.GRB.INTEGER, name="pancakes")
waffles = m.addVar(vtype=gp.GRB.INTEGER, name="waffles")

# Set objective function
m.setObjective(5 * pancakes + 7 * waffles, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * pancakes + 50 * waffles <= 5000, "flour_constraint")
m.addConstr(10 * pancakes + 15 * waffles <= 2000, "butter_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Pancakes: {pancakes.x}")
    print(f"Number of Waffles: {waffles.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

