
from gurobipy import *

# Create a new model
model = Model("Breakfast_Diner_Optimization")

# Define the decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pancakes")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="waffles")

# Define the objective function: Maximize profit
model.setObjective(5*x + 7*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x + 50*y <= 5000, "flour_constraint")
model.addConstr(10*x + 15*y <= 2000, "butter_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
