
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
P = model.addVar(lb=0, name="Pancakes")
W = model.addVar(lb=0, name="Waffles")

# Define the objective function
model.setObjective(5 * P + 7 * W, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(30 * P + 50 * W <= 5000, name="Flour_Constraint")
model.addConstr(10 * P + 15 * W <= 2000, name="Butter_Constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print(f"Optimal solution: Pancakes = {P.varValue}, Waffles = {W.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
