
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("arcade_shooter")

# Create variables
d = m.addVar(vtype=GRB.INTEGER, name="ducks")
g = m.addVar(vtype=GRB.INTEGER, name="geese")

# Set objective
m.setObjective(5 * d + 6 * g, GRB.MAXIMIZE)

# Add constraints
m.addConstr(d >= 5, "min_ducks")
m.addConstr(g >= 3, "min_geese")
m.addConstr(d <= 12, "max_ducks")
m.addConstr(g <= 7, "max_geese")
m.addConstr(d + g <= 15, "total_shots")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of ducks to shoot: {d.x}")
    print(f"Optimal number of geese to shoot: {g.x}")
    print(f"Maximum points: {m.objVal}")
else:
    print("Infeasible or unbounded")

