
from gurobipy import *

# Create a new model
m = Model("Arcade_Shooter")

# Define variables
d = m.addVar(vtype=GRB.INTEGER, name="ducks", lb=0)
g = m.addVar(vtype=GRB.INTEGER, name="geese", lb=0)

# Set objective function
m.setObjective(5*d + 6*g, GRB.MAXIMIZE)

# Add constraints
m.addConstr(d >= 5, "min_ducks")
m.addConstr(g >= 3, "min_geese")
m.addConstr(d <= 12, "max_ducks")
m.addConstr(g <= 7, "max_geese")
m.addConstr(d + g <= 15, "total_animals")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Shoot {d.x} ducks and {g.x} geese to maximize points.")
else:
    print("No optimal solution found. The problem might be infeasible.")
