
import gurobi

def solve_arcade_shooter_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    D = model.addVar(lb=5, ub=12, name="Ducks")
    G = model.addVar(lb=3, ub=7, name="Geese")

    # Objective function: Maximize 5D + 6G
    model.setObjective(5 * D + 6 * G, gurobi.GRB.MAXIMIZE)

    # Additional constraint: D + G <= 15
    model.addConstr(D + G <= 15, name="Total_Bullets")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Ducks = {D.X}, Geese = {G.X}")
        print(f"Maximum Points: {5 * D.X + 6 * G.X}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_arcade_shooter_problem()
