
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("advertising_optimization")

# Create decision variables
newspaper_ads = m.addVar(vtype=GRB.INTEGER, name="newspaper_ads")
tv_ads = m.addVar(vtype=GRB.INTEGER, name="tv_ads")

# Set objective function: Maximize total exposure
m.setObjective(30000 * newspaper_ads + 50000 * tv_ads, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2500 * newspaper_ads + 5000 * tv_ads <= 200000, "budget_constraint")  # Budget constraint
m.addConstr(newspaper_ads >= 12, "newspaper_min")  # Minimum newspaper ads
m.addConstr(newspaper_ads <= 24, "newspaper_max")  # Maximum newspaper ads
m.addConstr(tv_ads >= 10, "tv_min")  # Minimum TV ads

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Exposure: {m.objVal}")
    print(f"Number of Newspaper Ads: {newspaper_ads.x}")
    print(f"Number of TV Ads: {tv_ads.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

