
from gurobipy import *

# Create a new model
m = Model("Beverage_Company")

# Define variables
x = m.addVar(lb=12, ub=24, vtype=GRB.INTEGER, name="newspaper_advertisements")
y = m.addVar(lb=10, vtype=GRB.INTEGER, name="television_advertisements")

# Set the objective function
m.setObjective(30000*x + 50000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2500*x + 5000*y <= 200000, "budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of newspaper advertisements: {x.x}")
    print(f"Number of television advertisements: {y.x}")
    print(f"Maximum exposure: {m.objVal}")
else:
    print("No optimal solution found")
