
import gurobi

def solve_media_planning_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(lb=12, ub=24, vtype=gurobi.GRB.INTEGER, name="newspaper_advertisements")
    y = model.addVar(lb=10, vtype=gurobi.GRB.INTEGER, name="television_advertisements")

    # Objective function: Maximize exposure
    model.setObjective(30000*x + 50000*y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(2500*x + 5000*y <= 200000, name="budget_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Newspaper Advertisements: {x.varValue}")
        print(f"Television Advertisements: {y.varValue}")
        print(f"Maximum Exposure: {30000*x.varValue + 50000*y.varValue}")
    else:
        print("The model is infeasible or unbounded.")

solve_media_planning_problem()
