
import gurobipy as gp

# Create a new model
model = gp.Model("Pizza Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Pizza A")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Pizza B")

# Set the objective function
model.setObjective(3*x + 4*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x + 5*y <= 600, "Mozzarella Constraint")
model.addConstr(5*x + 3*y <= 500, "American Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Pizza A: {x.x}")
    print(f"Number of Pizza B: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

