
from gurobipy import *

# Create a new model
m = Model("Pizza_Profit")

# Define the decision variables
x = m.addVar(name="Pizza_A", vtype=GRB.INTEGER, lb=0)
y = m.addVar(name="Pizza_B", vtype=GRB.INTEGER, lb=0)

# Set the objective function to maximize profit
m.setObjective(3*x + 4*y, GRB.MAXIMIZE)

# Add constraints for mozzarella and American cheese availability
m.addConstr(4*x + 5*y <= 600, name="Mozzarella_Cheese_Constraint")
m.addConstr(5*x + 3*y <= 500, name="American_Cheese_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Make {x.x} Pizza A and {y.x} Pizza B")
    print(f"Maximum Profit: ${3*x.x + 4*y.x}")
else:
    print("No optimal solution found")

