
import gurobi

def solve_pizza_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_A = model.addVar(lb=0, name="Pizza_A")
    x_B = model.addVar(lb=0, name="Pizza_B")

    # Objective function: Maximize profit
    model.setObjective(3 * x_A + 4 * x_B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * x_A + 5 * x_B <= 600, name="Mozzarella_cheese_constraint")
    model.addConstr(5 * x_A + 3 * x_B <= 500, name="American_cheese_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Pizza A = {x_A.varValue}, Pizza B = {x_B.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_pizza_problem()
