
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("SupplementOptimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="SD_pills")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="LD_pills")

# Set objective function
m.setObjective(1*x + 1.5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + 2*y >= 15, "Calcium_req")
m.addConstr(4*x + y >= 20, "Iron_req")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Number of SD pills: {x.x}")
    print(f"Number of LD pills: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

