
from gurobipy import *

# Create a new model
m = Model("John_Supplementation")

# Define variables
x = m.addVar(name="SD_pills", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="LD_pills", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(1*x + 1.5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x + 2*y >= 15, name="Calcium_Constraint")
m.addConstr(4*x + 1*y >= 20, name="Iron_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x.x} SD pills")
    print(f"Buy {y.x} LD pills")
    print(f"Total cost: ${1*x.x + 1.5*y.x}")
else:
    print("No optimal solution found")

