
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="SD_pills", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of SD pills
    y = model.addVar(name="LD_pills", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of LD pills

    # Objective function: Minimize cost
    model.setObjective(x + 1.5 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x + 2 * y >= 15, name="calcium_constraint")  # Calcium requirement
    model.addConstr(4 * x + y >= 20, name="iron_constraint")  # Iron requirement

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has no optimal solution.")

solve_optimization_problem()
