
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("table_production")

    # Create variables
    x = m.addVar(vtype=gp.GRB.INTEGER, name="regular_tables")
    y = m.addVar(vtype=gp.GRB.INTEGER, name="standing_tables")

    # Set objective function
    m.setObjective(150 * x + 180 * y, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x <= 25, "team_A_limit")
    m.addConstr(y <= 50, "team_B_limit")
    m.addConstr(x + y <= 60, "machine_limit")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"Regular tables: {x.x}")
        print(f"Standing tables: {y.x}")
        print(f"Total profit: ${m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
