
from gurobipy import *

# Create a model
m = Model("FurnitureProduction")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_tables")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="standing_tables")

# Objective function: Maximize profit
m.setObjective(150*x + 180*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x <= 25, "Team_A_Capacity")
m.addConstr(y <= 50, "Team_B_Capacity")
m.addConstr(x + y <= 60, "Woodworking_Machine_Capacity")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular tables: {x.x}")
    print(f"Standing tables: {y.x}")
    print(f"Maximum profit: ${150*x.x + 180*y.x:.2f}")
else:
    print("No optimal solution found.")
