
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, ub=25, name="regular_tables")
y = model.addVar(lb=0, ub=50, name="standing_tables")

# Define the objective function
model.setObjective(150 * x + 180 * y, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 25, name="team_A_constraint")
model.addConstr(y <= 50, name="team_B_constraint")
model.addConstr(x + y <= 60, name="woodworking_machine_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Regular tables: {x.varValue}")
    print(f"Standing tables: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
