
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Carrot_Farming")

# Create variables
x = m.addVar(lb=0, name="Danvers_Acres")  # Acres of Danvers carrots
y = m.addVar(lb=0, name="Nantes_Acres")  # Acres of Nantes carrots

# Set objective function
m.setObjective(600*x + 300*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 150, "Land_Constraint")
m.addConstr(2.5*x + 3.7*y <= 300, "Labor_Constraint")
m.addConstr(100*x + 200*y <= 20000, "Maintenance_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of Danvers carrots")
    print(f"Plant {y.x:.2f} acres of Nantes carrots")
    print(f"Maximum Revenue: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

