
from gurobipy import *

# Create a new model
m = Model("Carrot_Farming")

# Define the variables
D = m.addVar(lb=0, name="Danvers")
N = m.addVar(lb=0, name="Nantes")

# Set the objective function
m.setObjective(600*D + 300*N, GRB.MAXIMIZE)

# Add constraints
m.addConstr(D + N <= 150, "Total_Land")
m.addConstr(2.5*D + 3.7*N <= 300, "Labor_Constraint")
m.addConstr(100*D + 200*N <= 20000, "Maintenance_Cost")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Acres of Danvers Carrots: {D.x}")
    print(f"Acres of Nantes Carrots: {N.x}")
    print(f"Total Net Revenue: ${m.objVal:.2f}")
else:
    print("No optimal solution found. The model is likely infeasible.")
