
import gurobi

def solve_carrot_farming_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    D = model.addVar(lb=0, name="Danvers_acres")
    N = model.addVar(lb=0, name="Nantes_acres")

    # Objective function: Maximize net revenue
    model.setObjective(600*D + 300*N, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(D + N <= 150, name="Land_constraint")

    # Labor constraint
    model.addConstr(2.5*D + 3.7*N <= 300, name="Labor_constraint")

    # Maintenance cost constraint
    model.addConstr(100*D + 200*N <= 20000, name="Maintenance_cost_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of Danvers carrots: {D.varValue}")
        print(f"Optimal acres of Nantes carrots: {N.varValue}")
        print(f"Maximum net revenue: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_carrot_farming_problem()
