
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("DonutProduction")

# Create decision variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # Regular donuts
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # Jelly-filled donuts

# Set objective function
model.setObjective(2*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 100, "Demand_Regular")
model.addConstr(x2 <= 75, "Demand_Jelly")
model.addConstr(x1 + x2 <= 120, "Capacity")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"Regular Donuts (x1): {x1.x}")
    print(f"Jelly-filled Donuts (x2): {x2.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

