
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define the decision variables
x1 = m.addVar(name="Regular_Donuts", lb=0)  # Number of regular donuts
x2 = m.addVar(name="Jelly_Filled_Donuts", lb=0)  # Number of jelly-filled donuts

# Set the objective function to maximize profit
m.setObjective(2*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, name="Regular_Demand")  # Demand constraint for regular donuts
m.addConstr(x2 <= 75, name="Jelly_Filled_Demand")  # Demand constraint for jelly-filled donuts
m.addConstr(x1 + x2 <= 120, name="Total_Capacity")  # Total capacity constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Donuts: {x1.x}")
    print(f"Jelly-Filled Donuts: {x2.x}")
    print(f"Maximum Profit: ${2*x1.x + 4*x2.x:.2f}")
else:
    print("No optimal solution found")
