
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="regular_donuts")
    x2 = model.addVar(lb=0, name="jelly_filled_donuts")

    # Objective function: Maximize profit
    model.setObjective(2*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 100, name="demand_regular")
    model.addConstr(x2 <= 75, name="demand_jelly_filled")
    model.addConstr(x1 + x2 <= 120, name="production_capacity")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal production levels:")
        print(f"Regular donuts: {x1.varValue}")
        print(f"Jelly filled donuts: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bakery_problem()
