
from gurobipy import *

# Create a new model
m = Model("Johns_Food_Problem")

# Define the decision variables
x_r = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rice_servings")
x_b = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="beef_servings")

# Set the objective function (minimize cost)
m.setObjective(5*x_r + 30*x_b, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x_r + 20*x_b >= 50, "protein_requirement")
m.addConstr(80*x_r + 200*x_b >= 1000, "carbs_requirement")
m.addConstr(x_r + 16*x_b >= 40, "fat_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rice servings: {x_r.x}")
    print(f"Beef servings: {x_b.x}")
    print(f"Total cost: ${5*x_r.x + 30*x_b.x:.2f}")
else:
    print("No optimal solution found")
