
import gurobi

def diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define sets
    foods = ['Rice', 'Beef']
    macronutrients = ['Protein', 'Carbs', 'Fat']

    # Define parameters
    cost = {'Rice': 5, 'Beef': 30}
    nutrient_content = {
        'Protein': {'Rice': 2, 'Beef': 20},
        'Carbs': {'Rice': 80, 'Beef': 200},
        'Fat': {'Rice': 1, 'Beef': 16}
    }
    requirements = {'Protein': 50, 'Carbs': 1000, 'Fat': 40}

    # Create variables
    x = {}
    for food in foods:
        x[food] = model.addVar(name=food, lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: minimize cost
    model.setObjective(gurobi.quicksum([cost[food] * x[food] for food in foods]), gurobi.GRB.MINIMIZE)

    # Constraints: meet nutrient requirements
    for nutrient, requirement in requirements.items():
        model.addConstr(gurobi.quicksum([nutrient_content[nutrient][food] * x[food] for food in foods]) >= requirement, name=nutrient)

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal servings:")
        for food in foods:
            print(f"{food}: {x[food].x:.2f}")
        print(f"Optimal cost: {model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the model
diet_problem()
