
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("factory_layout")

    # Create variables
    x = m.addVar(name="headset_space", lb=0)  # Headset space (sq ft)
    y = m.addVar(name="keyboard_space", lb=0) # Keyboard space (sq ft)


    # Set objective function
    m.setObjective(45*x + 80*y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 120, "space_constraint")
    m.addConstr(10*x + 12*y <= 5500, "cost_constraint")
    m.addConstr(2.5*x + 3.5*y <= 2500, "labor_constraint")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal Headset Space: {x.x:.2f} sq ft")
        print(f"Optimal Keyboard Space: {y.x:.2f} sq ft")
        print(f"Optimal Revenue: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
