
from gurobipy import *

# Create a model
m = Model("Factory_Optimization")

# Define variables
x_h = m.addVar(lb=0, name="headset_space")
x_k = m.addVar(lb=0, name="keyboard_space")

# Set the objective function
m.setObjective(45*x_h + 80*x_k, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_h + x_k <= 120, "space_constraint")
m.addConstr(2.5*x_h + 3.5*x_k <= 2500, "labor_constraint")
m.addConstr(10*x_h + 12*x_k <= 5500, "budget_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Headset space: {x_h.x}")
    print(f"Keyboard space: {x_k.x}")
    print(f"Maximum revenue: {m.objVal}")
else:
    print("No optimal solution found")

