
import gurobi

def optimize_factory_layout():
    # Create a new model
    model = gurobi.Model()

    # Variables
    H = model.addVar(lb=0, name="Headset_Space")
    K = model.addVar(lb=0, name="Keyboard_Space")

    # Objective function
    model.setObjective(45 * H + 80 * K, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(H + K <= 120, name="Space_Constraint")
    model.addConstr(2.5 * H + 3.5 * K <= 2500, name="Labor_Constraint")
    model.addConstr(10 * H + 12 * K <= 5500, name="Cost_Constraint")

    # Optimize
    model.optimize()

    # Status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Headset Space: {H.varValue} sq. feet")
        print(f"Keyboard Space: {K.varValue} sq. feet")
        print(f"Max Revenue: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization
optimize_factory_layout()
