
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Supplement_Optimization")

# Create decision variables
zeta = model.addVar(lb=0, name="zeta")
phi = model.addVar(lb=0, name="phi")

# Set objective function
model.setObjective(0.08 * zeta + 0.18 * phi, GRB.MINIMIZE)

# Add constraints
model.addConstr(0.15 * zeta + 0.20 * phi >= 25, "Iron_Requirement")
model.addConstr(0.20 * zeta + 0.45 * phi >= 40, "Vitamin_A_Requirement")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Zeta: {zeta.x:.2f} grams")
    print(f"Phi: {phi.x:.2f} grams")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

