
from gurobipy import *

# Create a model
m = Model("Daniel_Supplementation")

# Decision variables
Z = m.addVar(lb=0, name="Zeta_Supplementation")
P = m.addVar(lb=0, name="Phi_Supplementation")

# Objective function: Minimize total cost
m.setObjective(0.08*Z + 0.18*P, GRB.MINIMIZE)

# Constraints
m.addConstr(0.15*Z + 0.20*P >= 25, name="Iron_Requirement")
m.addConstr(0.20*Z + 0.45*P >= 40, name="VitaminA_Requirement")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Zeta supplementation: {Z.x} grams")
    print(f"Phi supplementation: {P.x} grams")
    print(f"Total cost: ${0.08*Z.x + 0.18*P.x}")
else:
    print("No optimal solution found.")
