
import gurobi

def solve_supplementation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    Z = model.addVar(lb=0, name="Zeta")
    Phi = model.addVar(lb=0, name="Phi")

    # Define the objective function
    model.setObjective(0.08 * Z + 0.18 * Phi, gurobi.GRB.MINIMIZE)

    # Add the iron requirement constraint
    model.addConstr(0.15 * Z + 0.20 * Phi >= 25, name="Iron_Requirement")

    # Add the vitamin A requirement constraint
    model.addConstr(0.20 * Z + 0.45 * Phi >= 40, name="Vitamin_A_Requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Zeta: {Z.varValue} grams")
        print(f"Phi: {Phi.varValue} grams")
        print(f"Cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_supplementation_problem()
