
import gurobipy as gp

# Create a new model
model = gp.Model("PhoneProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="large_phones")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="small_phones")

# Set objective function
model.setObjective(400 * x + 300 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * x + 15 * y <= 1500, "manufacturing_belt")
model.addConstr(12 * x + 10 * y <= 1000, "testing")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large phones to produce: {x.x}")
    print(f"Number of small phones to produce: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

