
from gurobipy import *

# Create a new model
m = Model("phone_production")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="large_phones")
y = m.addVar(vtype=GRB.CONTINUOUS, name="small_phones")

# Set the objective function to maximize profit
m.setObjective(400*x + 300*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 15*y <= 1500, "manufacturing_belt")
m.addConstr(12*x + 10*y <= 1000, "testing_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Produce {x.x:.0f} large phones")
    print(f"Produce {y.x:.0f} small phones")
    print(f"Total profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
