
import gurobi

def solve_phone_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(name="Large_Phones", vtype=gurobi.GRB.INTEGER, lb=0)
    S = model.addVar(name="Small_Phones", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Maximize profit
    model.setObjective(400*L + 300*S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*L + 15*S <= 1500, name="Manufacturing_Time")
    model.addConstr(12*L + 10*S <= 1000, name="Testing_Time")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Large phones = {L.varValue}, Small phones = {S.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_phone_production_problem()
