
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Wood Decor Optimization")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="vase_decors")
y = m.addVar(vtype=GRB.INTEGER, name="canvas_decors")

# Set objective function
m.setObjective(50*x + 85*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 18*y <= 400, "carving_time")
m.addConstr(14*x + 8*y <= 640, "polishing_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Vase Decors (x): {x.x}")
    print(f"Wood Canvas Decors (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

