
from gurobipy import *

# Create a new model
model = Model("Wood_Decor_Problem")

# Define the variables
x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="vase_decors")
x2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="wood_canvases")

# Define the objective function
model.setObjective(50*x1 + 85*x2, GRB.MAXIMIZE)

# Define the constraints
model.addConstr(20*x1 + 18*x2 <= 400, "carving_time")
model.addConstr(14*x1 + 8*x2 <= 640, "polishing_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of vase décors: {x1.x}")
    print(f"Number of wood canvases: {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 85*x2.x}")
else:
    print("No optimal solution found")
