
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
vase = model.addVar(lb=0, name="vase")
wood_canvas = model.addVar(lb=0, name="wood_canvas")

# Define the objective function
model.setObjective(50 * vase + 85 * wood_canvas, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(20 * vase + 18 * wood_canvas <= 400, name="carving_time_constraint")
model.addConstr(14 * vase + 8 * wood_canvas <= 640, name="polishing_time_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vase décors: {vase.varValue}")
    print(f"Wood canvases: {wood_canvas.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
