
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Fruit_Farming")

# Create variables
x = m.addVar(lb=0, name="Peaches_Acres")  # Acres of peaches
y = m.addVar(lb=0, name="Nectarines_Acres") # Acres of nectarines

# Set objective function
m.setObjective(200*x + 175*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 80, "Land_Constraint")
m.addConstr(3*x + 4.5*y <= 300, "Planting_Time_Constraint")
m.addConstr(2*x + 3*y <= 250, "Watering_Time_Constraint")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Solution:")
    print(f"  Peaches Acres: {x.x}")
    print(f"  Nectarines Acres: {y.x}")
    print(f"  Maximum Profit: ${m.objVal}")

