
from gurobipy import *

# Create a model
m = Model("Fruit_Farmer_Optimization")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peaches_acres")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="nectarines_acres")

# Objective function: Maximize profit
m.setObjective(200*x + 175*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x + 4.5*y <= 300, "planting_time")
m.addConstr(2*x + 3*y <= 250, "watering_time")
m.addConstr(x + y <= 80, "land_availability")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal acres of peaches: {x.x}")
    print(f"Optimal acres of nectarines: {y.x}")
    print(f"Maximum profit: ${200*x.x + 175*y.x}")
else:
    print("Model is infeasible")
