
import gurobi

def solve_fruit_farmer_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="acres_of_peaches")
    y = model.addVar(lb=0, name="acres_of_nectarines")

    # Set the objective function
    model.setObjective(200 * x + 175 * y, gurobi.GRB.MAXIMIZE)

    # Add the constraints
    model.addConstr(x + y <= 80, name="total_acres")
    model.addConstr(3 * x + 4.5 * y <= 300, name="planting_hours")
    model.addConstr(2 * x + 3 * y <= 250, name="watering_hours")

    # Optimize the model
    model.optimize()

    # Check if the model is infeasible
    if model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
        return

    # Print the solution
    print(f"Acres of peaches: {x.varValue}")
    print(f"Acres of nectarines: {y.varValue}")
    print(f"Max profit: {model.objVal}")

solve_fruit_farmer_problem()
