
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vehicle_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="bikes")  # Number of bikes
y = m.addVar(vtype=GRB.CONTINUOUS, name="cars")  # Number of cars

# Set objective function
m.setObjective(1000*x + 3000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 3*y <= 10, "assembly_constraint")
m.addConstr(0.5*x + y <= 8, "painting_constraint")
m.addConstr(x >= 0, "bikes_nonnegative")  # Ensure non-negative production
m.addConstr(y >= 0, "cars_nonnegative")  # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of bikes to produce: {x.x:.2f}")
    print(f"Number of cars to produce: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

