
from gurobipy import *

# Create a model
m = Model("Vehicle_Production")

# Define decision variables
x = m.addVar(name='bikes', vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name='cars', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function to maximize profit
m.setObjective(1000*x + 3000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 3*y <= 10, name='assembly_machine')
m.addConstr(0.5*x + y <= 8, name='painting_machine')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
