
import gurobi

def solve_vehicle_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="bikes", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="cars", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(1000*x + 3000*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + 3*y <= 10, name="assembly_machine")
    model.addConstr(0.5*x + y <= 8, name="painting_machine")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Produce {x.varValue} bikes and {y.varValue} cars.")
        print(f"Maximal profit: ${1000*x.varValue + 3000*y.varValue}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_vehicle_production_problem()
