
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("paint_mix")

# Create variables
x = model.addVar(lb=0, ub=1, name="x") # fraction of cheap paint
y = model.addVar(lb=0, ub=1, name="y") # fraction of expensive paint

# Set objective function
model.setObjective(0.3 * x + 1.5 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(50 * x + 90 * y >= 80, "quality_constraint")
model.addConstr(x + y == 1, "fraction_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Fraction of cheap paint (x): {x.x:.2f}")
    print(f"Fraction of expensive paint (y): {y.x:.2f}")
else:
    print("Infeasible or unbounded")

