
from gurobipy import *

# Create a new model
m = Model("paint_mix")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cheap_paint_fraction", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="expensive_paint_fraction", lb=0)

# Set the objective function
m.setObjective(0.30*x + 1.50*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(50*x + 90*y >= 80, "quality_rating")
m.addConstr(x + y == 1, "mix_fraction")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fraction of cheap paint: {x.x}")
    print(f"Fraction of expensive paint: {y.x}")
    print(f"Minimum cost per liter: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
